<?php


namespace App\Controllers\admin;

use App\Models\Featured_sections_model;
use App\Models\Partners_model;

class Featured_sections extends Admin
{
    public   $validation, $sections, $creator_id;
    public function __construct()
    {
        parent::__construct();
        helper(['form', 'url']);
        $this->sections = new Featured_sections_model();
        $this->validation = \Config\Services::validation();
        $this->creator_id = $this->userId;
        $this->superadmin = $this->session->get('email');
    }
    public function index()
    {

        $partners = new Partners_model();
        if ($this->isLoggedIn && $this->userIsAdmin) {
            $this->data['title'] = 'Featured section | Admin Panel';
            $this->data['main_page'] = 'featured_sections';
            $this->data['categories_name'] = fetch_details('categories', [], ['id', 'name']);
            $this->data['partners'] = $partners->list(true, '', 1000)['data'];
                 
            

            return view('backend/admin/template', $this->data);
        } else {
            return redirect('unauthorised');
        }
    }

    public function add_featured_section()
    {

       
      
        $permission = is_permitted($this->creator_id, 'add', 'featured_section');
        if ($permission) {

            if ($this->isLoggedIn && $this->userIsAdmin) {

                $section_type = ($this->request->getPost('section_type')) ? $this->request->getPost('section_type') : "";
                if (isset($section_type) && $section_type  == 'partners') {
                    $this->validation->setRules(
                        [
                            'title' => [
                                "rules" => 'required|trim',
                                "errors" => [
                                    "required" => "Please enter title for feature section "
                                ]
                            ],
                            'partners_ids' => [
                                "rules" => 'required',
                                "errors" => ["required" => "Please select atleast one partner"]
                            ],
                        ],
                    );
                } elseif (isset($section_type) && $section_type == 'categories') {
                    $this->validation->setRules(
                        [
                            'title' => [
                                "rules" => 'required|trim',
                                "errors" => [
                                    "required" => "Please enter title for feature section "
                                ]
                            ],
                            'category_item' => [
                                "rules" => 'required',
                                "errors" => ["required" => "Please select atleast one category"]
                            ],
                        ],
                    );
                } else {
                    $this->validation->setRules(
                        [
                            'title' => [
                                "rules" => 'required|trim',
                                "errors" => [
                                    "required" => "Please enter title for feature section "
                                ]
                            ],
                            'section_type' => [
                                "rules" => 'required',
                                "errors" => [
                                    "required" => "Please choose any Section Type "
                                ]
                            ],
                        ],
                    );
                }

                if (!$this->validation->withRequest($this->request)->run()) {
                    $errors = $this->validation->getErrors();
                    $response['error'] = true;
                    $response['message'] = $errors;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    $response['data'] = [];

                    return $this->response->setJSON($response);
                }

                $title = $this->request->getPost('title');
                $data = [];
                $data['title'] = $title;
                $data['section_type'] = $section_type;
                if (isset($section_type) && $section_type  == 'partners') {
                    $data['partners_ids'] = implode(',', $_POST['partners_ids']);
                    $data['category_ids'] = null;
                } else  if (isset($section_type) && $section_type == 'categories') {
                    $data['category_ids'] = implode(',', $_POST['category_item']);
                    $data['partners_ids'] = NULL;
                } else  if (isset($section_type) && $section_type == 'top_rated_partner') {
                
                    $data['limit'] =$this->request->getPost('limit');;
                } else {
                    $data['partners_ids'] = NULL;
                    $data['category_ids'] = null;
                }
                $data['status'] = $this->request->getPost('status');

                if ($this->sections->save($data)) {
                    $response = [
                        'error' => false,
                        'message' => "Featured section added successfully",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return json_encode($response);
                } else {
                    $response = [
                        'error' => true,
                        'message' => "Please try again....",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return json_encode($response);
                }
            } else {
                return redirect('unauthorised');
            }
        } else {
            $response = [
                'error' => true,
                'message' => "Sorry! you're not permitted to take this action",
                'csrfName' => csrf_token(),
                'csrfHash' => csrf_hash(),
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }


    public function list()
    {
        $multipleWhere = '';
        $db      = \Config\Database::connect();

        $builder = $db->table('sections s');
        $sortable_fields = ['id' => 'id', 'title' => 'title', 'categories' => 'categories', 'style' => 'style', 'service_type' => 'service_type'];
        $sort = 'id';
        $limit = 10;
        $condition  = [];
        $offset = 0;
        if (isset($_GET['offset'])) {
            $offset = $_GET['offset'];
        }
        if (isset($_GET['limit'])) {
            $limit = $_GET['limit'];
        }
        if (isset($_GET['sort'])) {
            if ($_GET['sort'] == 'id') {
                $sort = (isset($sortable_fields[$sort])) ? $sortable_fields[$sort] : "id";
            } else {
                $sort = $_GET['sort'];
            }
        }
        $order = "ASC";
        if (isset($_GET['order'])) {
            $order = $_GET['order'];
        }
        if (isset($_GET['search']) and $_GET['search'] != '') {
            $search = $_GET['search'];
            // print_r($search);
            $multipleWhere = ['`s.id`' => $search, '`s.title`' => $search, '`s.created_at`' => $search, 'section_type' => $search];
        }

        $total  = $builder->select(' COUNT(id) as `total` ');
        if (isset($_GET['id']) && $_GET['id'] != '') {
            $builder->where($condition);
        }

        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orWhere($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }

        $offer_count = $builder->get()->getResultArray();
        $total = $offer_count[0]['total'];



        $builder->select();
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orLike($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }

        $offer_recored = $builder->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();

        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();

        foreach ($offer_recored as $row) {
            $label = ($row['status'] == 1) ?
                '<div class="badge badge-success projects-badge"> Active </div>' :
                '<div class="badge badge-danger projects-badge"> Deactive </div>';
            $operations = '
                <button class="btn btn-success update_featured_section" data-id="' . $row['id'] . '"  data-toggle="modal" data-target="#update_modal" onclick="feature_section_id(this)"
                title = "Update the slider"> <i class="fa fa-pen" aria-hidden="true"></i> </button>  
                <button class="btn btn-danger delete-featured_section" data-id="' . $row['id'] . '" onclick="feature_section_id(this)" data-toggle="modal" data-target="#delete_modal" title = "Delete the featured section"> <i class="fa fa-trash" aria-hidden="true"></i> </button> 
            ';
            $tempRow['id'] = $row['id'];
            $tempRow['title'] = $row['title'];
            $tempRow['category_ids'] = $row['category_ids'];
            $tempRow['section_type'] = $row['section_type'];
            $tempRow['partners_ids'] = $row['partners_ids'];
            $tempRow['created_at'] = $row['created_at'];
            $tempRow['status'] = $row['status'];
            $tempRow['status_badge'] = $label;  
            
            
            $tempRow['operations'] = $operations;

            $rows[] = $tempRow;
        }
        $bulkData['rows'] = $rows;
        return json_encode($bulkData);
    }
    public function delete_featured_section()
    {
         
        $permission = is_permitted($this->creator_id, 'delete', 'featured_section');
        if ($permission) {
            if ($this->isLoggedIn && $this->userIsAdmin) {

                $id = $this->request->getPost('id');
                $db      = \Config\Database::connect();
                $builder = $db->table('sections');
                if ($builder->delete(['id' => $id])) {
                    $response = [
                        'error' => false,
                        'message' => 'Featured section deleted successfully',
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                } else {
                    $response = [
                        'error' => true,
                        'message' => 'An error occured during deleting this item',
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                }
            } else {
                return redirect('unauthorised');
            }
        } else {
            $response = [
                'error' => true,
                'message' => "Sorry! you're not permitted to take this action",
                'csrfName' => csrf_token(),
                'csrfHash' => csrf_hash(),
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }
    public function update_featured_section()
    {
       
        $id = $this->request->getPost('id');
        $db      = \Config\Database::connect();
        $builder = $db->table('sections');
        $permission = is_permitted($this->creator_id, 'update', 'featured_section');
        if ($permission) {
            if ($this->isLoggedIn && $this->userIsAdmin) {
                $section_type = ($this->request->getPost('section_type')) ? $this->request->getPost('section_type') : "";
                if (isset($section_type) && $section_type  == 'partners') {
                    $this->validation->setRules(
                        [
                            'title' => [
                                "rules" => 'required|trim',
                                "errors" => [
                                    "required" => "Please enter title for feature section "
                                ]
                            ],
                            'edit_partners_ids' => [
                                "rules" => 'required',
                                "errors" => ["required" => "Please select atleast one partner"]
                            ],
                        ],
                    );
                } elseif (isset($section_type) && $section_type == 'categories') {
                    $this->validation->setRules(
                        [
                            'title' => [
                                "rules" => 'required|trim',
                                "errors" => [
                                    "required" => "Please enter title for feature section "
                                ]
                            ],
                            'edit_Category_item' => [
                                "rules" => 'required',
                                "errors" => ["required" => "Please select atleast one category"]
                            ],
                        ],
                    );
                } else {
                    $this->validation->setRules(
                        [
                            'title' => [
                                "rules" => 'required|trim',
                                "errors" => [
                                    "required" => "Please enter title for feature section "
                                ]
                            ],
                            'section_type' => [
                                "rules" => 'required',
                                "errors" => [
                                    "required" => "Please choose any Section Type "
                                ]
                            ],
                        ],
                    );
                }

                if (!$this->validation->withRequest($this->request)->run()) {
                    $errors = $this->validation->getErrors();
                    $response['error'] = true;
                    $response['message'] = $errors;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    $response['data'] = [];

                    return $this->response->setJSON($response);
                }


                $partner_ids = $category_ids = null;
                $id = $this->request->getPost('id');
                $title = $this->request->getPost('title');

                $data['title'] = $title;
                $data['section_type'] = $_POST['section_type'];
                $data['category_ids'] = $category_ids;
                if ($_POST['section_type'] == 'partners') {
                    $partner_ids = implode(',', $_POST['edit_partners_ids']);
                    $data['partners_ids'] = $partner_ids;
                } elseif ($_POST['section_type'] == 'categories') {
                    $category_ids = implode(',', $_POST['edit_Category_item']);
                    $data['category_ids'] = $category_ids;
                }
                $data['status'] = $this->request->getPost('edit_status');

                if ($builder->update($data, ['id' => $id])) {
                    $response = [
                        'error' => false,
                        'message' => "Featured section updated successfully",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                } else {
                    $response = [
                        'error' => true,
                        'message' => "some erroe occuring",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                }
            } else {
                return redirect('unauthorised');
            }
        } else {
            $response = [
                'error' => true,
                'message' => "Sorry! you're not permitted to take this action",
                'csrfName' => csrf_token(),
                'csrfHash' => csrf_hash(),
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }
}
